package sample.consumer;

import java.util.List;

import com.nortel.soa.oi.cct.agentterminalservice.AgentTerminalService;
import com.nortel.soa.oi.cct.basenotification.NotificationEventHolderType;
import com.nortel.soa.oi.cct.basenotification.NotificationMessageHolderType;
import com.nortel.soa.oi.cct.basenotification.TerminalConnectionStateEventType;
import com.nortel.soa.oi.cct.basenotification.TerminalPropertyEventType;
import com.nortel.soa.oi.cct.contactservice.ContactService;
import com.nortel.soa.oi.cct.notificationconsumer.NotificationConsumer;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.TerminalConnectionState;
import com.nortel.soa.oi.cct.types.TerminalProperty;
import com.nortel.soa.oi.cct.types.agentterminalservice.GetLoginIdResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.TerminalRequest;
import com.nortel.soa.oi.cct.types.contactservice.AddressResponse;
import com.nortel.soa.oi.cct.types.contactservice.ContactRequest;

@javax.jws.WebService(name = "NotificationConsumer",
	    serviceName = "SOAOICCT_NotificationConsumer",
	    portName = "NotificationConsumer",
	    targetNamespace = "http://www.nortel.com/soa/oi/cct/NotificationConsumer",
	    endpointInterface = "com.nortel.soa.oi.cct.notificationconsumer.NotificationConsumer")
public class Consumer2Impl implements NotificationConsumer {

	private AgentTerminalService agentTerminalService;
	private ContactService contactService;
	
	private SsoToken ssoToken;
	
	public Consumer2Impl (AgentTerminalService agentTerminalService, SsoToken ssoToken, ContactService contactService) {
		this.agentTerminalService = agentTerminalService;
		this.ssoToken = ssoToken;
		this.contactService = contactService;
	}
	
	@Override
	public void notify(List<NotificationMessageHolderType> notificationMessage) {
 
	  
	        try {
	            for(NotificationMessageHolderType nmh : notificationMessage) {
	                NotificationEventHolderType notificationEventHolder = nmh.getMessage();
	  
	                //JOptionPane.showMessageDialog(null,"CONSUMER 2..." + notificationEventHolder.getEventType().name());
	                //System.err.println("CONSUMER 2..." + notificationEventHolder.getEventType().name());              
	                switch (notificationEventHolder.getEventType()) {
	                    case ADDRESS_PROPERTY:
	                    	//handle Address Property notification here
	                        break;
	                    case ADDRESS_STATE:
	                    	//handle Address Property notification here
	                    	break;
	                    case AGENT_PROPERTY:
	                    	//handle Agent Property notification here
	                    	break;
	                    case AGENT_STATE:
	                    	//handle agent state notification here
	                    	break;
	                    case CONNECTION_STATE:
	                    	//handle Address Property notification here
	                    	break;
	                    case CONTACT_PROPERTY:
	                    	//handle contact Property notification here
	                        break;
	                    case DEFAULT_TREATMENT:    
	                    	//handle default treatment notification here
	                        break;
	                    case FORCE_DISCONNECT:
	                    	//handle force disconnect notification here
	                        break;
	                    case SERVICE_PROVIDER_STATUS:
	                    	//handle Service Provider Status notification here
	                        break;
	                    case SYSTEM:
	                    	//handle System notification here
	                        break;
	                    case TERMINAL_CONNECTION_STATE:
	                    	printTerminalConnectionStateEventTypeDetails(notificationEventHolder.getTerminalConnectionStateEvent());
	                        break;
	                    case TERMINAL_PROPERTY:
	                    	printTerminalPropertyEventTypeDetails(notificationEventHolder.getTerminalPropertyEvent());
	                        break;
	                    case TERMINAL_STATE:
	                        break;
	                }
	             }
	       
	        } catch (Exception ex) {
	            ex.printStackTrace();
	            throw new RuntimeException(ex);
	        }
	}
	
	
	private void printTerminalConnectionStateEventTypeDetails(TerminalConnectionStateEventType inputTerminalConnectionStateEventType){
		StringBuilder outPut = new StringBuilder();
		
		ContactRequest contactRequest = new ContactRequest();
		contactRequest.setContact(inputTerminalConnectionStateEventType.getContact());
		contactRequest.setSsoToken(ssoToken);
		AddressResponse addressResponse_getCalledAddress = null;
		AddressResponse addressResponse_getCallingAddress = null;
		
		if(TerminalConnectionState.RINGING.equals(inputTerminalConnectionStateEventType.getNewState())) {
			try {
				addressResponse_getCalledAddress = contactService.getCalledAddress(contactRequest);
				addressResponse_getCallingAddress = contactService.getCallingAddress(contactRequest);
				
				outPut.append("\n");			
				outPut.append("Called Address : " + addressResponse_getCalledAddress.getAddress().getAddressName() + "\n");
				outPut.append("Calling Address : " + addressResponse_getCallingAddress.getAddress().getAddressName() + "\n");
				
			} catch (Exception ex) {
				System.err.println(ex.toString());
			}
		}
		
		System.out.println(outPut.toString());
	}
	
	
	
	private void printTerminalPropertyEventTypeDetails(TerminalPropertyEventType inputTerminalPropertyEventType) {		
		StringBuilder outPut = new StringBuilder();
		TerminalRequest terminalRequest = new TerminalRequest();
		terminalRequest.setSsoToken(ssoToken);
		terminalRequest.setTerminal(inputTerminalPropertyEventType.getTerminal());
		GetLoginIdResponse getLoginIdResponse = null;
		
		if(TerminalProperty.AGENT_LOGIN_SESSION.equals(inputTerminalPropertyEventType.getTerminalProperty())) {
			try {
				getLoginIdResponse = agentTerminalService.getLoginId(terminalRequest);
			} catch (Exception ex) {
				System.err.println(ex.toString());
			}
			
			if(getLoginIdResponse != null) 
				outPut.append("Agent " + getLoginIdResponse.getLoginId() + " AGENT_LOGIN_SESSION " );
			
		}
		
		if(TerminalProperty.AGENT_LOGIN_SESSION.equals(inputTerminalPropertyEventType.getTerminalProperty())) {
			try {
				getLoginIdResponse = agentTerminalService.getLoginId(terminalRequest);
			} catch (Exception ex) {
				System.err.println(ex.toString());
			}
			
			if(getLoginIdResponse != null) 
				outPut.append("AGENT_LOGIN_SESSION_ENDED");
			
		}
		
		
		if(TerminalProperty.READY_STATUS.equals(inputTerminalPropertyEventType.getTerminalProperty())) {
			try {
				getLoginIdResponse = agentTerminalService.getLoginId(terminalRequest);
			} catch (Exception ex) {
				System.err.println(ex.toString());
			}
			
			if(getLoginIdResponse != null) 
				outPut.append("Agent " + getLoginIdResponse.getLoginId() 
						+ " Terminal " + inputTerminalPropertyEventType.getTerminal().getTerminalName()
						+ " READY_STATUS " + inputTerminalPropertyEventType.getAgentTerminalPropertyReadyStatus().isStatus());

		}
		
		System.out.println(outPut.toString());
	}
	
	

}
